/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.wapper;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import com.wd.yamlhelper.util.UIManagers;
import com.wd.yamlhelper.wapper.JsonStructureComponentProvider;
import com.wd.yamlhelper.wapper.JsonWrapper;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStructureDialog
extends DialogWrapper {
    private final JsonWrapper wrapper;
    private Tree tree;
    private JsonStructureComponentProvider componentProvider;
    private VirtualFile file;

    public List<TreePath> getAllTreePaths() {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (root != null) {
            this.collectPaths(new TreePath(root), paths);
        }
        return paths;
    }

    private void collectPaths(TreePath parentPath, List<TreePath> paths) {
        paths.add(parentPath);
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode childNode = parentNode.getChildAt(i);
            TreePath childPath = parentPath.pathByAddingChild(childNode);
            this.collectPaths(childPath, paths);
        }
    }

    public void setPath(String parent, String text) {
        block3: {
            block2: {
                String[] split = (text = text.replace(" ", "")).split(":");
                if (split.length <= 1) break block2;
                List<TreePath> allTreePaths = this.getAllTreePaths();
                for (TreePath allTreePath : allTreePaths) {
                    String trim = parent.replace(":", ",").trim();
                    boolean contains = allTreePath.toString().contains(trim + " " + text);
                    if (!contains) continue;
                    this.tree.setSelectionPath(allTreePath);
                    this.tree.scrollPathToVisible(allTreePath);
                    return;
                }
                break block3;
            }
            if (!text.startsWith("-")) break block3;
            text = text.replaceFirst("-", "");
            List<TreePath> allTreePaths = this.getAllTreePaths();
            for (TreePath allTreePath : allTreePaths) {
                boolean contains = allTreePath.toString().contains(text);
                if (!contains) continue;
                this.tree.setSelectionPath(allTreePath);
                this.tree.scrollPathToVisible(allTreePath);
                return;
            }
        }
    }

    public JsonStructureDialog(JsonWrapper wrapper, VirtualFile file) {
        super((Project)null, true);
        this.wrapper = wrapper;
        this.file = file;
        this.setModal(false);
        this.init();
    }

    @Nullable
    public JComponent createCenterPanel() {
        this.componentProvider = new JsonStructureComponentProvider(this.wrapper, this.getRootPane(), true, this.file);
        this.tree = this.componentProvider.getTree();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        UIManagers.expandAll(this.tree, new TreePath(root));
        JPanel rootPanel = this.componentProvider.getTreeComponent();
        rootPanel.setPreferredSize(new Dimension(400, 470));
        return rootPanel;
    }

    public void rebuild(JsonWrapper wrapper) {
        this.componentProvider.rebuildTree(wrapper);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            JsonStructureDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.tree;
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "";
    }

    public void show() {
        ApplicationManager.getApplication().invokeLater(() -> super.show());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/wd/yamlhelper/wapper/JsonStructureDialog", "createActions"));
    }
}

