/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.wd.yamlhelper.gui.YamlGui;
import com.wd.yamlhelper.i18.YamlHelperBoundle;
import com.wd.yamlhelper.notify.NotificationUtil;
import com.wd.yamlhelper.parser.ConfigEntry;
import com.wd.yamlhelper.parser.YamlParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YamlUtil {
    private static final Logger LOG = Logger.getInstance(YamlGui.class);

    public static String getFileJson(VirtualFile file, Project project) {
        String text = FileUtil.readString((String)file.getPath(), (String)"UTF-8");
        text = YamlUtil.matchAndReplace(text);
        List<ConfigEntry> configEntries = YamlParser.parseYaml(file.getPath());
        Yaml yaml = new Yaml();
        Iterable objects = yaml.loadAll(text);
        StringBuilder sb = new StringBuilder();
        try {
            for (Object object : objects) {
                ObjectMapper mapper = new ObjectMapper();
                String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                for (ConfigEntry configEntry : configEntries) {
                    if (!StrUtil.isNotBlank((CharSequence)s) || !s.contains(configEntry.get$Key())) continue;
                    s = s.replace(configEntry.get$Key(), configEntry.getValue().toString());
                }
                sb.append(s);
            }
        }
        catch (Exception e) {
            NotificationUtil.showWarningNotification(project, YamlHelperBoundle.messageOnSystem("YamlHelper.Parse.Error", new Object[0]), YamlHelperBoundle.messageOnSystem("YamlHelper.Parse.Error", new Object[0]) + "\uff01" + e.getMessage());
        }
        return sb.toString().replaceAll("\r\n", "\n");
    }

    public static String getConfigJson(String filePath) {
        Yaml yaml = new Yaml();
        try {
            Iterable objects = yaml.loadAll((InputStream)new FileInputStream(filePath));
            StringBuilder sb = new StringBuilder();
            for (Object object : objects) {
                ObjectMapper mapper = new ObjectMapper();
                sb.append(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object));
            }
            return sb.toString().replaceAll("\r\n", "\n");
        }
        catch (Exception e) {
            NotificationUtil.showWarningNotification(YamlHelperBoundle.messageOnSystem("YamlHelper.Parse.Error", new Object[0]), YamlHelperBoundle.messageOnSystem("YamlHelper.Parse.Error", new Object[0]) + "\uff01" + e.getMessage());
            return "";
        }
    }

    public static String matchAndReplace(String text) {
        String regex = "(?<!['\"])@([^@\\n ]+)@(?!=['\"])";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "'" + matcher.group() + "'");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

