/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIManagers
implements Disposable {
    public static UIManagers getInstance() {
        return new UIManagers();
    }

    public static TextEditor createDefaultTextEditor(Project project, FileType fileType, String text) {
        LightVirtualFile lightVirtualFile = new LightVirtualFile("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
        return (TextEditor)TextEditorProvider.getInstance().createEditor(project, (VirtualFile)lightVirtualFile);
    }

    public static void expandAll(Tree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                UIManagers.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public static void expandSecondaryNode(Tree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        UIManagers.expandSecondaryNode(tree, root);
    }

    public static void expandSecondaryNode(Tree tree, TreeNode root) {
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            UIManagers.expandAll(tree, new TreePath(node.getPath()));
        }
    }

    public static void collapseAll(Tree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                UIManagers.collapseAll(tree, path);
            }
        }
        tree.collapsePath(parent);
    }

    public static void collapseSecondaryNode(Tree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        UIManagers.collapseSecondaryNode(tree, root);
    }

    public static void collapseSecondaryNode(Tree tree, TreeNode root) {
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            UIManagers.collapseAll(tree, new TreePath(node.getPath()));
        }
    }

    public static Map<TreePath, Boolean> recordExpandedStates(JTree tree) {
        HashMap<TreePath, Boolean> expandedStates = new HashMap<TreePath, Boolean>();
        Enumeration<TreePath> paths = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
        if (paths != null) {
            while (paths.hasMoreElements()) {
                TreePath path = paths.nextElement();
                expandedStates.put(path, true);
            }
        }
        return expandedStates;
    }

    public static void restoreExpandedStates(JTree tree, Map<TreePath, Boolean> expandedStates) {
        for (Map.Entry<TreePath, Boolean> entry : expandedStates.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            tree.expandPath(entry.getKey());
        }
    }

    public static void updateComponentColorsScheme(JComponent component) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        component.setForeground(scheme.getDefaultForeground());
        component.setBackground(scheme.getDefaultBackground());
    }

    public static void updateEditorColorsScheme(EditorEx editor) {
        editor.setColorsScheme(EditorColorsManager.getInstance().getGlobalScheme());
    }

    public static <T> JComponent wrapListWithFilter(@NotNull JList<? extends T> list, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            UIManagers.$$$reportNull$$$0(0);
        }
        return ListWithFilter.wrap(list, (JScrollPane)ScrollPaneFactory.createScrollPane(list), namer, (boolean)highlightAllOccurrences);
    }

    public static JBFont consolasFont(int size) {
        return JBUI.Fonts.create((String)"Consolas", (int)size);
    }

    public static JBFont jetBrainsMonoFont(int size) {
        return JBUI.Fonts.create((String)"JetBrains Mono", (int)size);
    }

    public static JBFont microsoftYaHeiUIFont(int size) {
        return JBUI.Fonts.create((String)"Microsoft YaHei UI", (int)size);
    }

    public static JBFont microsoftYaHeiUIFont(int size, int style) {
        JBFont font = JBUI.Fonts.create((String)"Microsoft YaHei UI", (int)size);
        switch (style) {
            case 1: {
                font = font.asBold();
                break;
            }
            case 2: {
                font = font.asItalic();
            }
        }
        return font;
    }

    public static Border getCommentBorder(JComponent component) {
        Insets insets = ComponentPanelBuilder.computeCommentInsets((JComponent)component, (boolean)true);
        insets.bottom -= 4;
        return new JBEmptyBorder(insets);
    }

    public static void controlEnableCheckBox(JCheckBox checkBox, boolean enable) {
        UIManagers.controlEnableToggleButton(checkBox, enable);
    }

    public static void controlEnableRadioButton(JRadioButton radioButton, boolean enable) {
        UIManagers.controlEnableToggleButton(radioButton, enable);
    }

    public static void controlEnableToggleButton(JToggleButton toggleButton, boolean enable) {
        if (enable) {
            if (!toggleButton.isEnabled()) {
                toggleButton.setEnabled(true);
            }
        } else if (toggleButton.isEnabled()) {
            toggleButton.setEnabled(false);
        }
    }

    public static void setHelpLabel(JLabel label, String description) {
        label.setIcon(AllIcons.General.ContextHelp);
        new HelpTooltip().setDescription(description).installOn((JComponent)label);
    }

    public static Component getFocusComponent() {
        Component component = IdeFocusManager.getGlobalInstance().getFocusOwner();
        return Objects.nonNull(component) ? component : null;
    }

    @Nullable
    public static JComponent getWindowComponent(Project project) {
        IdeFrame window = (IdeFrame)NotificationsManagerImpl.findWindowForBalloon((Project)project);
        return window != null ? window.getComponent() : null;
    }

    public static Font getCommentFont(Font font) {
        return new FontUIResource(font.deriveFont((float)((double)font.getSize() - 0.7)));
    }

    public static void repaintEditor(Editor editor) {
        UIManagers.repaintComponent(editor.getComponent());
    }

    public static void repaintComponent(JComponent component) {
        component.revalidate();
        component.repaint();
    }

    public static void setText(JComponent textField, String text) {
        if (textField instanceof JTextField) {
            ((JTextField)textField).setText(text);
        } else if (textField instanceof EditorTextField) {
            ((EditorTextField)textField).setText(text);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/wd/yamlhelper/util/UIManagers", "wrapListWithFilter"));
    }
}

