/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.wd.yamlhelper.util.Json5Util;
import com.wd.yamlhelper.wapper.ArrayWrapper;
import com.wd.yamlhelper.wapper.JsonWrapper;
import com.wd.yamlhelper.wapper.ObjectWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class JsonUtil {
    public static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).enable(new DeserializationFeature[]{DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS})).disable(new JsonWriteFeature[]{JsonWriteFeature.WRITE_NAN_AS_STRINGS}).build();
    private static final Logger LOG = Logger.getInstance(JsonUtil.class);

    public static boolean isJson(String text) {
        try {
            JsonNode node = MAPPER.readTree(text);
            return node instanceof ArrayNode || node instanceof ObjectNode;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isJsonArray(String json) {
        try {
            JsonNode jsonNode = MAPPER.readTree(json);
            return jsonNode instanceof ArrayNode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJsonObject(String json) {
        try {
            JsonNode jsonNode = MAPPER.readTree(json);
            return jsonNode instanceof ObjectNode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JsonWrapper parse(String json) {
        if (JsonUtil.isJsonObject(json)) {
            return JsonUtil.parseObject(json);
        }
        if (JsonUtil.isJsonArray(json)) {
            return JsonUtil.parseArray(json);
        }
        return null;
    }

    public static ObjectWrapper parseObject(String text) {
        return new ObjectWrapper((Object)JsonUtil.toObject(JsonUtil.ensureJson(text), LinkedHashMap.class));
    }

    public static ArrayWrapper parseArray(String text) {
        return new ArrayWrapper((Object)JsonUtil.toObject(JsonUtil.ensureJson(text), ArrayList.class));
    }

    public static String formatJson(String jsonStr) {
        try {
            return JsonUtil.formatJson(MAPPER.readValue(jsonStr, Object.class));
        }
        catch (Exception e) {
            LOG.error("Formatting failure", (Throwable)e);
            return null;
        }
    }

    public static String formatJson(Object data) {
        try {
            if (data instanceof JsonNode) {
                return MAPPER.writer((PrettyPrinter)new NoSpaceAndLFPrettyPrinter()).writeValueAsString(data);
            }
            return new GsonBuilder().serializeSpecialFloatingPointValues().serializeNulls().setPrettyPrinting().disableHtmlEscaping().create().toJson(data);
        }
        catch (Exception e) {
            LOG.error("Formatting failure", (Throwable)e);
            return null;
        }
    }

    public static String compressJson(String jsonStr) {
        try {
            return JsonUtil.compressJson(MAPPER.readTree(jsonStr));
        }
        catch (Exception e) {
            LOG.error("Compression failure", (Throwable)e);
            return null;
        }
    }

    public static String compressJson(Object data) {
        try {
            return MAPPER.writeValueAsString(data);
        }
        catch (Exception e) {
            LOG.error("Compression failure", (Throwable)e);
            return null;
        }
    }

    public static String toJsonStr(Object obj) {
        return JsonUtil.formatJson(obj);
    }

    public static <T> T toObject(String jsonStr, Class<T> clz) {
        try {
            return (T)MAPPER.readValue(jsonStr, clz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isNotJsonArray(String jsonStr, boolean isJson) {
        return isJson ? !JsonUtil.isJsonArray(jsonStr) : !Json5Util.isJson5Array(jsonStr);
    }

    public static String ensureJson(String text) {
        return JsonUtil.isJson(text) ? text : JsonUtil.extractJson(text);
    }

    public static boolean canResolveToJson(String text) {
        return JsonUtil.isJson(text) || StrUtil.isNotBlank((CharSequence)JsonUtil.extractJson(text));
    }

    public static String extractJson(String includeJsonStr) {
        if (StrUtil.isBlank((CharSequence)includeJsonStr)) {
            return "";
        }
        try {
            String json = StringEscapeUtils.unescapeJson((String)includeJsonStr);
            if (JsonUtil.isJson(json)) {
                return json;
            }
            json = JsonUtil.extractJsonStringOnRegular(includeJsonStr);
            if (StrUtil.isNotBlank((CharSequence)json)) {
                return json;
            }
            json = JsonUtil.extractJsonString(includeJsonStr);
            return JsonUtil.isJson(json) ? json : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String extractJsonStringOnRegular(String includeJsonStr) {
        List<String> jsonStrings = JsonUtil.findJsonStrings(includeJsonStr);
        return CollUtil.isNotEmpty(jsonStrings) ? jsonStrings.get(0) : "";
    }

    public static List<String> findJsonStrings(String text) {
        ArrayList<String> jsonStrings = new ArrayList<String>();
        String jsonPattern = "\\{[^\\}]+\\}|\\[[^\\]]+\\]";
        Pattern pattern = Pattern.compile(jsonPattern);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String jsonString = matcher.group();
            if (!JsonUtil.isJson(jsonString)) continue;
            jsonStrings.add(StrUtil.trim((CharSequence)jsonString));
        }
        return jsonStrings;
    }

    private static String extractJsonString(String includeJsonStr) {
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < includeJsonStr.length(); ++i) {
            if (includeJsonStr.charAt(i) != '{' && includeJsonStr.charAt(i) != '[') continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            return "";
        }
        int count = 1;
        for (int i = startIndex + 1; i < includeJsonStr.length(); ++i) {
            char c = includeJsonStr.charAt(i);
            if (c == '{' || c == '[') {
                ++count;
                continue;
            }
            if (c != '}' && c != ']' || --count != 0) continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            return "";
        }
        return includeJsonStr.substring(startIndex, endIndex + 1);
    }

    private static class NoSpaceAndLFPrettyPrinter
    extends DefaultPrettyPrinter {
        public NoSpaceAndLFPrettyPrinter() {
            this._objectIndenter = new DefaultIndenter("  ", "\n");
        }

        public DefaultPrettyPrinter createInstance() {
            return new NoSpaceAndLFPrettyPrinter();
        }

        public void writeObjectFieldValueSeparator(JsonGenerator g) throws IOException {
            g.writeRaw(": ");
        }
    }
}

