/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonAssistantUtil {
    public static String truncateText(String text, int maxLength, String omitHint) {
        if (text.length() > maxLength) {
            return text.substring(0, maxLength) + " " + omitHint;
        }
        return text;
    }

    public static Class<?> getClassByName(String classQualifiedName) {
        try {
            return Class.forName(classQualifiedName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object readStaticFinalFieldValue(Class<?> clz, String fieldName) {
        Field matchField = null;
        try {
            for (Field field : ClassUtil.getDeclaredFields(clz)) {
                if (!Objects.equals(fieldName, field.getName()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                matchField = field;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Objects.isNull(matchField) ? null : ReflectUtil.getStaticFieldValue(matchField);
    }

    public static Method getMethod(Object obj, String methodName, Object ... params) {
        Class<?> clazz = obj.getClass();
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        return ReflectUtil.getMethod(clazz, (String)methodName, (Class[])paramTypes);
    }

    public static Object invokeMethod(Object obj, String methodName, Object ... params) {
        Method method = JsonAssistantUtil.getMethod(obj, methodName, params);
        if (Objects.nonNull(method)) {
            return ReflectUtil.invoke((Object)obj, (Method)method, (Object[])params);
        }
        return null;
    }

    private static boolean isChineseCharacter(char c) {
        return c >= '\u4e00' && c <= '\u9fff';
    }

    public static String normalizeLineEndings(String text) {
        return text == null ? null : text.replaceAll("\\r\\n|\\r|\\n", "\n");
    }

    public static boolean containsMultipleChineseCharacters(String text) {
        int chineseCount = 0;
        for (char c : text.toCharArray()) {
            if (!JsonAssistantUtil.isChineseCharacter(c) || ++chineseCount <= 1) continue;
            return true;
        }
        return false;
    }

    public static Object detectType(String str) {
        Object number = JsonAssistantUtil.getNumber(str);
        if (Objects.nonNull(number)) {
            return number;
        }
        Object bool = JsonAssistantUtil.getBoolean(str);
        if (Objects.nonNull(bool)) {
            return bool;
        }
        Object date = JsonAssistantUtil.getDate(str);
        if (Objects.nonNull(date)) {
            return date;
        }
        return str;
    }

    public static Object getNumber(String str) {
        try {
            if (NumberUtil.isNumber((CharSequence)str)) {
                return NumberUtil.parseNumber((String)str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Object getBoolean(String str) {
        if (StrUtil.equalsIgnoreCase((CharSequence)Boolean.TRUE.toString(), (CharSequence)str)) {
            return true;
        }
        if (StrUtil.equalsIgnoreCase((CharSequence)Boolean.FALSE.toString(), (CharSequence)str)) {
            return false;
        }
        return null;
    }

    public static Object getDate(String str) {
        try {
            return DateUtil.parse((CharSequence)str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unicodeToString(String unicodeString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unicodeString.length(); ++i) {
            if (i + 5 < unicodeString.length() && unicodeString.charAt(i) == '\\' && unicodeString.charAt(i + 1) == 'u') {
                String hexCode = unicodeString.substring(i + 2, i + 6);
                int codePoint = Integer.parseInt(hexCode, 16);
                sb.append(Character.toChars(codePoint));
                i += 5;
                continue;
            }
            sb.append(unicodeString.charAt(i));
        }
        return sb.toString();
    }

    public static <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        ArrayList<T> result = new ArrayList<T>();
        if (Objects.isNull(enumeration)) {
            return result;
        }
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasStringType(Object ... array) {
        if (!ArrayUtil.isNotEmpty((Object[])array)) return false;
        if (!Arrays.stream(array).anyMatch(String.class::isInstance)) return false;
        return true;
    }

    public static boolean allElementsAreNumeric(Object ... array) {
        return ArrayUtil.isNotEmpty((Object[])array) && Arrays.stream(array).allMatch(el -> el instanceof Byte || el instanceof Short || el instanceof Integer || el instanceof Long || el instanceof Float || el instanceof Double || el instanceof Character);
    }

    public static String toCamel(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        String[] split = text.split(" ");
        if (split.length > 1) {
            text = JsonAssistantUtil.blankToSnakeCase(text);
        }
        return NamingCase.toCamelCase((CharSequence)text);
    }

    public static String blankToSnakeCase(String text) {
        text = text.replaceAll("^\\s+", "_");
        text = text.replaceAll("\\s+$", "_");
        text = text.replaceAll("\\s+", "_");
        return text;
    }

    public static boolean isInheritedFrom(Object obj, String fullyQualifiedName) {
        if (obj == null || StrUtil.isBlank((CharSequence)fullyQualifiedName)) {
            return false;
        }
        for (Class<?> currentClass = obj.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!fullyQualifiedName.equals(currentClass.getName())) continue;
            return true;
        }
        return false;
    }
}

