/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.util;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.wd.yamlhelper.i18.YamlHelperBoundle;

public class FileChooseUtil {
    public void chooseSingleFile(Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.File", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.File", new Object[0]));
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file != null) {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file.getPath());
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public void chooseMultipleFiles(Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, true);
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.File", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.OneOrMany.File", new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        if (files.length > 0) {
            for (VirtualFile file : files) {
                System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file.getPath());
            }
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public void chooseDirectory(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.Directory", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.Directory", new Object[0]));
        VirtualFile directory = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (directory != null) {
            System.out.println("\u9009\u62e9\u7684\u76ee\u5f55: " + directory.getPath());
        } else {
            System.out.println("\u672a\u9009\u62e9\u76ee\u5f55");
        }
    }

    public void chooseFileWithFactory(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.File", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.File", new Object[0]));
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file != null) {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file.getPath());
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public void chooseTxtFile(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.TextFile", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.TextFile", new Object[0]));
        descriptor.withFileFilter(file -> file.getExtension() != null && file.getExtension().equalsIgnoreCase("txt"));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file2.getPath());
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public void chooseJavaFile(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.JavaFile", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.JavaFile", new Object[0]));
        descriptor.withFileFilter(file -> file.getExtension() != null && file.getExtension().equalsIgnoreCase("java"));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file2.getPath());
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public void chooseTextOrMarkdownFile(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.TextFile", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.TextOrMdFile", new Object[0]));
        descriptor.withFileFilter(file -> {
            String extension = file.getExtension();
            return extension != null && (extension.equalsIgnoreCase("txt") || extension.equalsIgnoreCase("md"));
        });
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file2.getPath());
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public static String chooseYamlFile(Project project) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.Yaml.File", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.YamlFile", new Object[0]));
        descriptor.withFileFilter(file -> file.getExtension() != null && (file.getExtension().equalsIgnoreCase("yaml") || file.getExtension().equalsIgnoreCase("yml")));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            return file2.getPath();
        }
        return null;
    }

    public void chooseTxtFileWithValidation(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.TextFile", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.TextFile", new Object[0]));
        descriptor.withFileFilter(file -> file.getExtension() != null && file.getExtension().equalsIgnoreCase("txt"));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            if (file2.getExtension() != null && file2.getExtension().equalsIgnoreCase("txt")) {
                System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Choosed.File", new Object[0]) + file2.getPath());
            } else {
                Messages.showErrorDialog((String)YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.TextFile", new Object[0]), (String)YamlHelperBoundle.messageOnSystem("YamlHelper.File.Type.Error", new Object[0]));
            }
        } else {
            System.out.println(YamlHelperBoundle.messageOnSystem("YamlHelper.Not.Choose.File", new Object[0]));
        }
    }

    public static String chooseTxtFileStrict(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.TextFile", new Object[0]));
        descriptor.setDescription(YamlHelperBoundle.messageOnSystem("YamlHelper.Please.Choose.One.TextFile", new Object[0]));
        descriptor.withFileFilter(file -> file.isDirectory() || file.getExtension() != null && file.getExtension().equalsIgnoreCase("txt"));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (file2 != null) {
            return file2.getPath();
        }
        return null;
    }
}

