/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.parser;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.wd.yamlhelper.parser.ConfigEntry;
import com.wd.yamlhelper.util.YamlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    public static List<ConfigEntry> parseYaml(String filePath) {
        Map yamlData;
        String text = FileUtil.readString((String)filePath, (String)"UTF-8");
        text = YamlUtil.matchAndReplace(text);
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        Yaml yaml = new Yaml();
        try {
            yamlData = (Map)yaml.load(text);
        }
        catch (Exception e) {
            return entries;
        }
        if (yamlData != null) {
            YamlParser.flattenYaml("", yamlData, entries);
        }
        return entries;
    }

    private static void flattenYaml(String parentKey, Map<String, Object> yamlData, List<ConfigEntry> entries) {
        for (Map.Entry<String, Object> entry : yamlData.entrySet()) {
            String fullKey = null;
            try {
                fullKey = parentKey.isEmpty() ? entry.getKey() : parentKey + "." + entry.getKey();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            Object value = entry.getValue();
            if (StrUtil.isBlank((CharSequence)fullKey)) continue;
            if (value instanceof Map) {
                YamlParser.flattenYaml(fullKey, (Map)value, entries);
                continue;
            }
            entries.add(new ConfigEntry(fullKey, value));
        }
    }
}

