/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.node;

import com.wd.yamlhelper.node.JsonTreeNodeType;
import javax.swing.tree.DefaultMutableTreeNode;

public class JsonTreeNode
extends DefaultMutableTreeNode {
    private Object value;
    private JsonTreeNodeType nodeType;
    private Integer size;

    public JsonTreeNode(Object userObject) {
        super(userObject);
    }

    public JsonTreeNode(Object userObject, Object value, JsonTreeNodeType nodeType, Integer size) {
        super(userObject);
        this.value = value;
        this.nodeType = nodeType;
        this.size = size;
    }

    public Object getValue() {
        return this.value;
    }

    public JsonTreeNode setValue(Object value) {
        this.value = value;
        return this;
    }

    public JsonTreeNodeType getNodeType() {
        return this.nodeType;
    }

    public JsonTreeNode setNodeType(JsonTreeNodeType nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public JsonTreeNode setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public String toString() {
        if (JsonTreeNodeType.JSONObject.equals((Object)this.nodeType) || JsonTreeNodeType.JSONArray.equals((Object)this.nodeType) || JsonTreeNodeType.JSONObjectElement.equals((Object)this.nodeType) || JsonTreeNodeType.JSONArrayElement.equals((Object)this.nodeType)) {
            return this.getUserObject().toString();
        }
        return this.getUserObject().toString() + ":" + this.value;
    }

    public void updateSize() {
        int newSize;
        if ((JsonTreeNodeType.JSONObject.equals((Object)this.nodeType) || JsonTreeNodeType.JSONArray.equals((Object)this.nodeType) || JsonTreeNodeType.JSONObjectElement.equals((Object)this.nodeType)) && (newSize = this.getChildCount()) != this.size) {
            this.size = newSize;
            JsonTreeNode parent = (JsonTreeNode)this.getParent();
            if (parent != null) {
                parent.updateSize();
            }
        }
    }

    public void removeAndUpdateSize(JsonTreeNode child) {
        this.remove(child);
        this.updateSize();
    }
}

