/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.jump;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.wd.yamlhelper.node.JsonTreeNode;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlLineNumberFinder {
    public static int getLineNumber(AnActionEvent event, JsonTreeNode node) {
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return -1;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.exists()) {
            return -1;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (node.getValue() == null) {
            String s = node.getUserObject() + ":";
            int offset = document.getText().indexOf(s);
            int lineNumber = document.getLineNumber(offset);
            return lineNumber;
        }
        String s = node.getUserObject() + ": " + node.getValue();
        int offset = document.getText().indexOf(s);
        if (offset == -1) {
            s = node.getUserObject() + ": \"" + node.getValue() + "\"";
            offset = document.getText().indexOf(s);
            if (offset == -1) {
                return -1;
            }
        }
        int lineNumber = document.getLineNumber(offset);
        return lineNumber;
    }

    public static int getObjectLineNumber(AnActionEvent event, JsonTreeNode node) {
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return -1;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.exists()) {
            return -1;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        String s = node.getUserObject() + ":";
        int offset = document.getText().indexOf(s);
        if (offset == -1) {
            s = node.getUserObject() + ": \"" + node.getValue() + "\"";
            offset = document.getText().indexOf(s);
            if (offset == -1) {
                return -1;
            }
        }
        int lineNumber = document.getLineNumber(offset);
        return lineNumber;
    }

    private static int findLineNumber(Document document, Object data, JsonTreeNode node, int currentLine) {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map map = (Map)data;
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getKey()).equals(node.getUserObject()) && entry.getValue().toString().equals(node.getValue().toString())) {
                        return currentLine + 1;
                    }
                    int line = YamlLineNumberFinder.findLineNumber(document, entry.getValue(), node, currentLine);
                    if (line != -1) {
                        return line;
                    }
                    currentLine = document.getLineNumber(document.getText().indexOf((String)entry.getKey(), currentLine));
                }
                break block5;
            }
            if (!(data instanceof List)) break block5;
            List list = (List)data;
            for (Object item : list) {
                int line = YamlLineNumberFinder.findLineNumber(document, item, node, currentLine);
                if (line == -1) continue;
                return line;
            }
        }
        return -1;
    }

    public static int getLineNumber(AnActionEvent event, String targetKey) {
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return -1;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.exists()) {
            return -1;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document != null) {
            Yaml yaml = new Yaml();
            try {
                Map data = (Map)yaml.load(document.getText());
                if (data != null) {
                    return YamlLineNumberFinder.findLineNumber(document, (Object)data, targetKey, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    private static int findLineNumber(Document document, Object data, String targetKey, int currentLine) {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map map = (Map)data;
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getKey()).equals(targetKey)) {
                        return currentLine + 1;
                    }
                    int line = YamlLineNumberFinder.findLineNumber(document, entry.getValue(), targetKey, currentLine);
                    if (line != -1) {
                        return line;
                    }
                    currentLine = document.getLineNumber(document.getText().indexOf((String)entry.getKey(), currentLine));
                }
                break block5;
            }
            if (!(data instanceof List)) break block5;
            List list = (List)data;
            for (Object item : list) {
                int line = YamlLineNumberFinder.findLineNumber(document, item, targetKey, currentLine);
                if (line == -1) continue;
                return line;
            }
        }
        return -1;
    }
}

