/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.gui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.wd.yamlhelper.constant.FileTypeHolder;
import com.wd.yamlhelper.editor.MyEditorFactory;
import com.wd.yamlhelper.gui.Donation;
import com.wd.yamlhelper.gui.GenerateProperties;
import com.wd.yamlhelper.i18.YamlHelperBoundle;
import com.wd.yamlhelper.icon.PluginIcons;
import com.wd.yamlhelper.util.JsonUtil;
import com.wd.yamlhelper.util.YamlUtil;
import com.wd.yamlhelper.wapper.JsonStructureDialog;
import com.wd.yamlhelper.wapper.JsonWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class YamlGui
implements Disposable {
    private JPanel rootPanel;
    private JPanel editPanel;
    private Editor jsonEditor;
    private JButton refresh;
    private JButton yamlSetting;
    private JRadioButton showTree;
    private JRadioButton showJson;
    private JButton generateProperties;
    private JButton donation;
    private VirtualFile file;
    private JsonStructureDialog dialog;
    private Project project;

    public YamlGui(Project project, VirtualFile file) {
        this.file = file;
        this.project = project;
        this.$$$setupUI$$$();
        this.refresh.setIcon(PluginIcons.INTELLIJ_REFRESH);
        this.refresh.setToolTipText(YamlHelperBoundle.messageOnSystem("YamlHelper.Refresh", new Object[0]));
        this.refresh.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                YamlGui.this.refresh.setIcon(PluginIcons.INTELLIJ_REFRESH_Enter);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                YamlGui.this.refresh.setIcon(PluginIcons.INTELLIJ_REFRESH);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                YamlGui.this.refresh.setIcon(PluginIcons.INTELLIJ_REFRESH);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                YamlGui.this.refresh.setIcon(PluginIcons.INTELLIJ_REFRESH_Enter);
            }
        });
        this.yamlSetting.setIcon(PluginIcons.SETTING);
        this.yamlSetting.setToolTipText(YamlHelperBoundle.messageOnSystem("YamlHelper.Set", new Object[0]));
        this.yamlSetting.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                YamlGui.this.yamlSetting.setIcon(PluginIcons.SETTING_Enter);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                YamlGui.this.yamlSetting.setIcon(PluginIcons.SETTING);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                YamlGui.this.yamlSetting.setIcon(PluginIcons.SETTING);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                YamlGui.this.yamlSetting.setIcon(PluginIcons.SETTING_Enter);
            }
        });
        this.generateProperties.setIcon(PluginIcons.PROPERTIES_FILE);
        this.generateProperties.setToolTipText(YamlHelperBoundle.messageOnSystem("YamlHelper.Generate.Properties.File", new Object[0]));
        this.generateProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                YamlGui.this.generateProperties.setIcon(PluginIcons.PROPERTIES_FILE_Enter);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                YamlGui.this.generateProperties.setIcon(PluginIcons.PROPERTIES_FILE);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                YamlGui.this.generateProperties.setIcon(PluginIcons.PROPERTIES_FILE);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                YamlGui.this.generateProperties.setIcon(PluginIcons.PROPERTIES_FILE_Enter);
            }
        });
        this.donation.setIcon(PluginIcons.Donation);
        this.donation.setContentAreaFilled(false);
        this.donation.setBorderPainted(false);
        this.donation.setToolTipText(YamlHelperBoundle.messageOnSystem("YamlHelper.Donation", new Object[0]));
        this.donation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                YamlGui.this.donation.setIcon(PluginIcons.Donation_Enter);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                YamlGui.this.donation.setIcon(PluginIcons.Donation);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                YamlGui.this.donation.setIcon(PluginIcons.Donation);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                YamlGui.this.donation.setIcon(PluginIcons.Donation_Enter);
            }
        });
        String json = YamlUtil.getFileJson(file, project);
        MyEditorFactory factory = new MyEditorFactory(project);
        this.jsonEditor = factory.createEditor("result.json5", FileTypeHolder.JSON5, json);
        JsonWrapper jsonWrapper = JsonUtil.parse(JsonUtil.ensureJson(json));
        this.dialog = new JsonStructureDialog(jsonWrapper, file);
        this.editPanel.add((Component)this.dialog.createCenterPanel(), "Center");
        Application application = ApplicationManager.getApplication();
        this.refresh.addActionListener(e -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            if (this.showJson.isSelected()) {
                application.runWriteAction(() -> this.jsonEditor.getDocument().setText((CharSequence)YamlUtil.getFileJson(file, project)));
            } else {
                JsonWrapper jsonWrapper1 = JsonUtil.parse(JsonUtil.ensureJson(YamlUtil.getFileJson(file, project)));
                this.dialog.rebuild(jsonWrapper1);
            }
        });
        this.showJson.addActionListener(e -> application.runWriteAction(() -> {
            this.editPanel.removeAll();
            this.jsonEditor.getDocument().setText((CharSequence)YamlUtil.getFileJson(file, project));
            this.editPanel.add((Component)this.jsonEditor.getComponent(), "Center");
            this.editPanel.revalidate();
            this.editPanel.repaint();
        }));
        this.showTree.addActionListener(e -> {
            this.editPanel.removeAll();
            JsonWrapper jsonWrapper1 = JsonUtil.parse(JsonUtil.ensureJson(YamlUtil.getFileJson(file, project)));
            this.dialog = new JsonStructureDialog(jsonWrapper1, file);
            this.editPanel.add((Component)this.dialog.createCenterPanel(), "Center");
            this.editPanel.revalidate();
            this.editPanel.repaint();
        });
        this.yamlSetting.addActionListener(e -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "Yaml Helper"));
        this.generateProperties.addActionListener(e -> {
            String path = file.getPath();
            String propertiesPath = path.replace(".yaml", ".yml").replace(".yml", ".properties");
            GenerateProperties generateProperties = new GenerateProperties(project, path, propertiesPath);
            generateProperties.show();
        });
        this.donation.addActionListener(e -> {
            Donation donation = new Donation(project);
            donation.show();
        });
    }

    public JsonStructureDialog getDialog() {
        return this.dialog;
    }

    public JComponent getRootComponent() {
        return this.rootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.rootPanel;
    }

    public void dispose() {
        if (this.jsonEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.jsonEditor);
            this.jsonEditor = null;
        }
    }

    public void selectNotify() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        JPanel jPanel2;
        this.rootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 10, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.editPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 10, 0, 3, 3, 3, null, null, null));
        this.refresh = jButton4 = new JButton();
        jButton4.setText("");
        jButton4.setToolTipText("");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 8, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 7, 1, 1, 0, 1, 6, 1, null, null, null));
        this.yamlSetting = jButton3 = new JButton();
        jButton3.setText("");
        jButton3.setToolTipText("");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 5, 1, 1, 0, 1, 3, 0, null, null, null));
        this.showTree = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Tree");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.showJson = jRadioButton = new JRadioButton();
        jRadioButton.setText("Json");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.generateProperties = jButton2 = new JButton();
        jButton2.setText("");
        jButton2.setToolTipText("");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.donation = jButton = new JButton();
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(0, 9, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

