/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.config;

import cn.hutool.json.JSONObject;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.wd.yamlhelper.i18.YamlHelperBoundle;
import com.wd.yamlhelper.icon.PluginIcons;
import com.wd.yamlhelper.persistent.YamlPersistent;
import com.wd.yamlhelper.util.FileChooseUtil;
import com.wd.yamlhelper.util.JsonUtil;
import com.wd.yamlhelper.util.YamlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class YamlHelperConfigUI {
    YamlPersistent instance;
    private JPanel rootPanel;
    private JTextField transPath;
    private JButton configFile;
    private JCheckBox yamlInputHelp;
    private JCheckBox copyPathIgnoreRoot;
    private JCheckBox yamlSync;
    private JLabel chooseYamlLabel;
    private JLabel useSetLabel;

    public YamlHelperConfigUI() {
        this.$$$setupUI$$$();
        this.instance = YamlPersistent.getInstance();
        this.transPath.setText(this.instance.getYamlFilePath());
        this.chooseYamlLabel.setText(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.Yaml.MarkFile", new Object[0]));
        this.useSetLabel.setText(YamlHelperBoundle.messageOnSystem("YamlHelper.Use.Setting", new Object[0]));
        this.yamlInputHelp.setText(YamlHelperBoundle.messageOnSystem("YamlHelper.Input.Help", new Object[0]));
        this.copyPathIgnoreRoot.setText(YamlHelperBoundle.messageOnSystem("YamlHelper.Copy.Path.Ignore.Root", new Object[0]));
        this.configFile.setIcon(PluginIcons.INTELLIJ_CONFIG_FILE);
        this.configFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                YamlHelperConfigUI.this.configFile.setIcon(PluginIcons.INTELLIJ_CONFIG_FILE_Enter);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                YamlHelperConfigUI.this.configFile.setIcon(PluginIcons.INTELLIJ_CONFIG_FILE);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                YamlHelperConfigUI.this.configFile.setIcon(PluginIcons.INTELLIJ_CONFIG_FILE);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                YamlHelperConfigUI.this.configFile.setIcon(PluginIcons.INTELLIJ_CONFIG_FILE_Enter);
            }
        });
        this.configFile.setToolTipText(YamlHelperBoundle.messageOnSystem("YamlHelper.Choose.Yaml.File", new Object[0]));
        this.yamlSync.setText(YamlHelperBoundle.messageOnSystem("YamlHelper.Automatically.Select.Node.When.Line.Caret.Changes", new Object[0]));
        this.copyPathIgnoreRoot.setSelected(this.instance.isCopyPathIgnoreRoot());
        this.yamlSync.setSelected(this.instance.isYamlSync());
        this.yamlInputHelp.setSelected(this.instance.isYamlInputHelp());
        this.configFile.addActionListener(e -> this.choseYamlFile1());
    }

    private void choseYamlFile1() {
        String path = FileChooseUtil.chooseYamlFile(null);
        if (path != null) {
            this.transPath.setText(path);
        }
    }

    public JPanel createComponent() {
        return this.rootPanel;
    }

    public boolean isModified() {
        if (this.instance.getYamlFilePath() == null && this.transPath.getText() != null) {
            return true;
        }
        if (!this.instance.getYamlFilePath().equals(this.transPath.getText())) {
            return true;
        }
        if (!this.instance.isCopyPathIgnoreRoot() == this.copyPathIgnoreRoot.isSelected()) {
            return true;
        }
        if (!this.instance.isYamlInputHelp() == this.yamlInputHelp.isSelected()) {
            return true;
        }
        return !this.instance.isYamlSync() == this.yamlSync.isSelected();
    }

    public void apply() {
        this.instance.setYamlFilePath(this.transPath.getText());
        JSONObject object = JsonUtil.toObject(YamlUtil.getConfigJson(this.transPath.getText()), JSONObject.class);
        this.instance.setJsonObject(object);
        this.instance.setYamlInputHelp(this.yamlInputHelp.isSelected());
        this.instance.setCopyPathIgnoreRoot(this.copyPathIgnoreRoot.isSelected());
        this.instance.setYamlSync(this.yamlSync.isSelected());
    }

    public void reset() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField;
        JButton jButton;
        JLabel jLabel2;
        JPanel jPanel;
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.chooseYamlLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.configFile = jButton = new JButton();
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.transPath = jTextField = new JTextField();
        jTextField.setToolTipText("Yaml\u683c\u5f0f\u6587\u4ef6");
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.copyPathIgnoreRoot = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("");
        jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.yamlInputHelp = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.useSetLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.yamlSync = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

