/*
 * Decompiled with CFR 0.152.
 */
package com.wd.yamlhelper.action;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.treeStructure.Tree;
import com.wd.yamlhelper.i18.YamlHelperBoundle;
import com.wd.yamlhelper.node.JsonTreeNode;
import com.wd.yamlhelper.node.JsonTreeNodeType;
import com.wd.yamlhelper.persistent.YamlPersistent;
import com.wd.yamlhelper.util.PlatformUtil;
import java.util.ArrayList;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class CopyNodePathAction
extends DumbAwareAction {
    private final Tree tree;

    public CopyNodePathAction(Tree tree) {
        super(YamlHelperBoundle.messageOnSystem("YamlHelper.Copy.Node.Path", new Object[0]), YamlHelperBoundle.messageOnSystem("YamlHelper.Copy.Node.Path.ToolTip", new Object[0]), null);
        this.tree = tree;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object[] paths;
        if (e == null) {
            CopyNodePathAction.$$$reportNull$$$0(0);
        }
        if (ArrayUtil.isNotEmpty((Object[])(paths = this.tree.getSelectionPaths()))) {
            ArrayList<String> pathList = new ArrayList<String>();
            for (Object path : paths) {
                StringBuilder pathString = new StringBuilder();
                for (Object element : ((TreePath)path).getPath()) {
                    JsonTreeNode node = (JsonTreeNode)element;
                    JsonTreeNodeType nodeType = node.getNodeType();
                    YamlPersistent instance = YamlPersistent.getInstance();
                    if (instance.isCopyPathIgnoreRoot() && node.getUserObject().equals("root")) continue;
                    if (JsonTreeNodeType.JSONArrayElement == nodeType) {
                        TreeNode parent = node.getParent();
                        int index = parent.getIndex(node);
                        pathString.append("[").append(index).append("]");
                        continue;
                    }
                    pathString.append(pathString.length() > 0 ? "." : "").append(node.getUserObject());
                }
                pathList.add(pathString.toString());
            }
            PlatformUtil.setClipboard(StrUtil.join((CharSequence)", \n", pathList));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CopyNodePathAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wd/yamlhelper/action/CopyNodePathAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wd/yamlhelper/action/CopyNodePathAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

